/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.ast.InlineLinkNode;
import icyllis.flexmark.util.sequence.BasedSequence;

public class Image
extends InlineLinkNode {
    private BasedSequence urlContent = BasedSequence.NULL;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.textOpeningMarker, this.text, this.textClosingMarker, this.linkOpeningMarker, this.urlOpeningMarker, this.url, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.urlContent, this.titleOpeningMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker, this.linkClosingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        Image.delimitedSegmentSpanChars(out, this.textOpeningMarker, this.text, this.textClosingMarker, "text");
        Image.segmentSpanChars(out, this.linkOpeningMarker, "linkOpen");
        Image.delimitedSegmentSpanChars(out, this.urlOpeningMarker, this.url, this.urlClosingMarker, "url");
        if (this.pageRef.isNotNull()) {
            Image.segmentSpanChars(out, this.pageRef, "pageRef");
        }
        if (this.anchorMarker.isNotNull()) {
            Image.segmentSpanChars(out, this.anchorMarker, "anchorMarker");
        }
        if (this.anchorRef.isNotNull()) {
            Image.segmentSpanChars(out, this.anchorRef, "anchorRef");
        }
        if (this.urlContent.isNotNull()) {
            Image.segmentSpanChars(out, this.urlContent, "urlContent");
        }
        Image.delimitedSegmentSpanChars(out, this.titleOpeningMarker, this.title, this.titleClosingMarker, "title");
        Image.segmentSpanChars(out, this.linkClosingMarker, "linkClose");
    }

    public Image() {
    }

    public Image(BasedSequence chars) {
        super(chars);
    }

    public Image(BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence titleOpenMarker, BasedSequence title, BasedSequence titleCloseMarker, BasedSequence linkCloseMarker) {
        super(textOpenMarker, text, textCloseMarker, linkOpenMarker, url, titleOpenMarker, title, titleCloseMarker, linkCloseMarker);
    }

    public Image(BasedSequence chars, BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence titleOpenMarker, BasedSequence title, BasedSequence titleCloseMarker, BasedSequence linkCloseMarker) {
        super(chars, textOpenMarker, text, textCloseMarker, linkOpenMarker, url, titleOpenMarker, title, titleCloseMarker, linkCloseMarker);
    }

    public Image(BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence linkCloseMarker) {
        super(textOpenMarker, text, textCloseMarker, linkOpenMarker, url, linkCloseMarker);
    }

    public Image(BasedSequence chars, BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence linkCloseMarker) {
        super(chars, textOpenMarker, text, textCloseMarker, linkOpenMarker, url, linkCloseMarker);
    }

    @Override
    public void setTextChars(BasedSequence textChars) {
        int textCharsLength = textChars.length();
        this.textOpeningMarker = textChars.subSequence(0, 2);
        this.text = (BasedSequence)textChars.subSequence(2, textCharsLength - 1).trim();
        this.textClosingMarker = textChars.subSequence(textCharsLength - 1, textCharsLength);
    }

    public void setUrlContent(BasedSequence urlContent) {
        this.urlContent = urlContent;
    }

    public BasedSequence getUrlContent() {
        return this.urlContent;
    }
}

